using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using BeWise.SharpBuilderTools.Ant;

namespace BeWise.SharpBuilderTools.Gui {

	public class FrmNAntMultipleRunner : System.Windows.Forms.Form
	{
		// *************************************************************************
		//                            Constructor
		// *************************************************************************

		public FrmNAntMultipleRunner()
		{
			InitializeComponent();
		}

		// *************************************************************************
		//                            Destructor
		// *************************************************************************

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		// *************************************************************************
		//                            Private
		// *************************************************************************

		private System.Windows.Forms.GroupBox groupbox;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button btOk;
		private System.Windows.Forms.Button btCancel;
		private System.Windows.Forms.Button btAdd;
		private System.Windows.Forms.Button btRemove;
		private System.Windows.Forms.ListBox lbSource;
		private System.Windows.Forms.ListBox lbToRun;
		private System.Windows.Forms.Button btDown;
		private System.Windows.Forms.Button btUp;

		private System.ComponentModel.Container components = null;

		private BaseAnt fCurrentAnt;
		private BaseAntProject fProject;
		private string[] fSelectedTargets;

		#region Windows Form Designer generated code
		private void InitializeComponent()
		{
			this.groupbox = new System.Windows.Forms.GroupBox();
			this.btDown = new System.Windows.Forms.Button();
			this.btUp = new System.Windows.Forms.Button();
			this.btRemove = new System.Windows.Forms.Button();
			this.btAdd = new System.Windows.Forms.Button();
			this.lbToRun = new System.Windows.Forms.ListBox();
			this.lbSource = new System.Windows.Forms.ListBox();
			this.label1 = new System.Windows.Forms.Label();
			this.btOk = new System.Windows.Forms.Button();
			this.btCancel = new System.Windows.Forms.Button();
			this.groupbox.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupbox
			// 
			this.groupbox.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.groupbox.Controls.Add(this.btDown);
			this.groupbox.Controls.Add(this.btUp);
			this.groupbox.Controls.Add(this.btRemove);
			this.groupbox.Controls.Add(this.btAdd);
			this.groupbox.Controls.Add(this.lbToRun);
			this.groupbox.Controls.Add(this.lbSource);
			this.groupbox.Controls.Add(this.label1);
			this.groupbox.Location = new System.Drawing.Point(8, 8);
			this.groupbox.Name = "groupbox";
			this.groupbox.Size = new System.Drawing.Size(560, 328);
			this.groupbox.TabIndex = 0;
			this.groupbox.TabStop = false;
			this.groupbox.Text = "Targets";
			// 
			// btDown
			// 
			this.btDown.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btDown.Location = new System.Drawing.Point(256, 168);
			this.btDown.Name = "btDown";
			this.btDown.Size = new System.Drawing.Size(48, 24);
			this.btDown.TabIndex = 6;
			this.btDown.Text = "Down";
			this.btDown.Click += new System.EventHandler(this.btDown_Click);
			// 
			// btUp
			// 
			this.btUp.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btUp.Location = new System.Drawing.Point(256, 136);
			this.btUp.Name = "btUp";
			this.btUp.Size = new System.Drawing.Size(48, 24);
			this.btUp.TabIndex = 5;
			this.btUp.Text = "Up";
			this.btUp.Click += new System.EventHandler(this.btUp_Click);
			// 
			// btRemove
			// 
			this.btRemove.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btRemove.Location = new System.Drawing.Point(256, 104);
			this.btRemove.Name = "btRemove";
			this.btRemove.Size = new System.Drawing.Size(48, 24);
			this.btRemove.TabIndex = 4;
			this.btRemove.Text = "-";
			this.btRemove.Click += new System.EventHandler(this.btRemove_Click);
			// 
			// btAdd
			// 
			this.btAdd.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btAdd.Location = new System.Drawing.Point(256, 72);
			this.btAdd.Name = "btAdd";
			this.btAdd.Size = new System.Drawing.Size(48, 24);
			this.btAdd.TabIndex = 3;
			this.btAdd.Text = "+";
			this.btAdd.Click += new System.EventHandler(this.btAdd_Click);
			// 
			// lbToRun
			// 
			this.lbToRun.HorizontalScrollbar = true;
			this.lbToRun.Location = new System.Drawing.Point(312, 48);
			this.lbToRun.Name = "lbToRun";
			this.lbToRun.Size = new System.Drawing.Size(232, 264);
			this.lbToRun.TabIndex = 2;
			this.lbToRun.DoubleClick += new System.EventHandler(this.lbToRun_DoubleClick);
			// 
			// lbSource
			// 
			this.lbSource.HorizontalScrollbar = true;
			this.lbSource.Location = new System.Drawing.Point(16, 48);
			this.lbSource.Name = "lbSource";
			this.lbSource.Size = new System.Drawing.Size(232, 264);
			this.lbSource.Sorted = true;
			this.lbSource.TabIndex = 1;
			this.lbSource.DoubleClick += new System.EventHandler(this.lbSource_DoubleClick);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(104, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Select your targets:";
			// 
			// btOk
			// 
			this.btOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btOk.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btOk.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btOk.Location = new System.Drawing.Point(408, 344);
			this.btOk.Name = "btOk";
			this.btOk.TabIndex = 1;
			this.btOk.Text = "Ok";
			// 
			// btCancel
			// 
			this.btCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btCancel.Location = new System.Drawing.Point(488, 344);
			this.btCancel.Name = "btCancel";
			this.btCancel.TabIndex = 2;
			this.btCancel.Text = "Cancel";
			// 
			// FrmNAntMultipleRunner
			// 
			this.AcceptButton = this.btOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btCancel;
			this.ClientSize = new System.Drawing.Size(576, 374);
			this.Controls.Add(this.btCancel);
			this.Controls.Add(this.btOk);
			this.Controls.Add(this.groupbox);
			this.ForeColor = System.Drawing.Color.Black;
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "FrmNAntMultipleRunner";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "NAnt Runner";
			this.groupbox.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

        private void btAdd_Click(object sender, System.EventArgs e) {
            if (lbSource.SelectedItem != null) {               
                lbToRun.Items.Add(lbSource.SelectedItem);
                lbSource.Items.Remove(lbSource.SelectedItem);
            }
        }

        private void btRemove_Click(object sender, System.EventArgs e) {
            if (lbToRun.SelectedItem != null) {               
                lbSource.Items.Add(lbToRun.SelectedItem);
                lbToRun.Items.Remove(lbToRun.SelectedItem);
            }       
        }

        private void btUp_Click(object sender, System.EventArgs e) {
            if (lbToRun.SelectedItem != null && lbToRun.SelectedIndex != 0) {               
                int _Sel = lbToRun.SelectedIndex;

                lbToRun.Items.Insert(lbToRun.SelectedIndex -1, lbToRun.SelectedItem);
                lbToRun.Items.RemoveAt(lbToRun.SelectedIndex);
                
                lbToRun.SelectedIndex = _Sel - 1;
            }              
        }

        private void btDown_Click(object sender, System.EventArgs e) {
            if (lbToRun.SelectedItem != null && lbToRun.SelectedIndex != (lbToRun.Items.Count -1)) {               
                lbToRun.Items.Insert(lbToRun.SelectedIndex, lbToRun.Items[lbToRun.SelectedIndex + 1]);
                lbToRun.Items.RemoveAt(lbToRun.SelectedIndex + 1);
            }                     
		}

        private void lbSource_DoubleClick(object sender, System.EventArgs e) {
            btAdd_Click(sender, null);
        }

        private void lbToRun_DoubleClick(object sender, System.EventArgs e) {
            btRemove_Click(sender, null);
        }

		private void LoadProjectInList() {
            lbSource.Items.Clear();

			for (int i = 0; i < Project.Targets.Length - 1; i++){
				lbSource.Items.Add(Project.Targets[i].Name);
			}
		}
		// *************************************************************************
		//                            Properties
		// *************************************************************************

		public BaseAnt CurrentAnt {
			get {
				return fCurrentAnt;
			}

			set {
				fCurrentAnt = value;

				if (value != null) {
					this.Text = CurrentAnt.Name + " Runner";
				}
			}
		}

		public BaseAntProject Project {
			get {
				return fProject;
			}
			set {
				fProject = value;
				LoadProjectInList();
			}
		}

        public string[] SelectedTargets {
            get {
                ArrayList _Arr = new ArrayList();
                   
                for (int i = 0; i < lbToRun.Items.Count; i++) {
                    _Arr.Add(lbToRun.Items[i]);
                }
                
                string[] _res = new string[_Arr.Count];
                
                for (int j = 0; j < _Arr.Count; j ++) {
                    _res[j] = _Arr[j] as string;
                }
                
                return _res;       
            }
            set {
                fSelectedTargets = value;
            }
        }
	}
}
